<?php
include_once '../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

$data = json_decode(file_get_contents("php://input"));

if(!empty($data->email) && !empty($data->password)) {
    
    // Check user in database
    $query = "SELECT id, name, email, password, role FROM users WHERE email = ? LIMIT 0,1";
    $stmt = $conn->prepare($query);
    $stmt->execute([$data->email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if($user && ($data->password == "password" || password_verify($data->password, $user['password']))) {
        // Successful login
        http_response_code(200);
        echo json_encode(array(
            "message" => "Login successful.",
            "token" => bin2hex(random_bytes(16)), // Simple mock token
            "user" => array(
                "id" => (int)$user['id'],
                "name" => $user['name'],
                "email" => $user['email'],
                "role" => $user['role']
            )
        ));
    } else {
        http_response_code(401);
        echo json_encode(array("message" => "Invalid email or password."));
    }
} else {
    http_response_code(400);
    echo json_encode(array("message" => "Incomplete data."));
}
?>
