<?php
include_once '../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

$id = isset($_GET['id']) ? (int) $_GET['id'] : 0;

if ($id <= 0) {
    http_response_code(400);
    echo json_encode(array("message" => "Invalid comic ID."));
    exit();
}

try {
    // Fetch comic details
    $query = "SELECT id, title, author, artist, cover_url as cover, rating, status, genre, description as synopsis FROM comics WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->execute([$id]);
    $comic = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($comic) {
        // Fetch chapters
        $query_chapters = "SELECT id, title, created_at as date FROM chapters WHERE comic_id = ? ORDER BY chapter_number DESC";
        $stmt_chapters = $conn->prepare($query_chapters);
        $stmt_chapters->execute([$id]);

        $comic['chapters'] = array();
        while ($chapter = $stmt_chapters->fetch(PDO::FETCH_ASSOC)) {
            $chapter['id'] = (int) $chapter['id'];
            $comic['chapters'][] = $chapter;
        }

        http_response_code(200);
        echo json_encode($comic);
    } else {
        http_response_code(404);
        echo json_encode(array("message" => "Comic not found."));
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(array("message" => "Database error: " . $e->getMessage()));
}
?>