<?php
include_once '../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

try {
    $query = "SELECT id, title, author, cover_url as image, rating, status, genre FROM comics ORDER BY created_at DESC";
    $stmt = $conn->prepare($query);
    $stmt->execute();

    $comics = array();
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        // Ensure types are correct for Flutter
        $row['id'] = (int) $row['id'];
        $row['rating'] = (float) $row['rating'];
        $comics[] = $row;
    }

    http_response_code(200);
    echo json_encode($comics);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(array("message" => "Error fetching comics: " . $e->getMessage()));
}
?>