<?php
include_once '../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

$query = isset($_GET['q']) ? $_GET['q'] : '';
$genre = isset($_GET['genre']) ? $_GET['genre'] : '';

// Mock search results
$results = array();
$mock_comics = array(
    array("id" => 1, "title" => "The Beginning After The End", "genre" => "Fantasy", "cover" => "https://via.placeholder.com/300x450.png?text=TBATE"),
    array("id" => 2, "title" => "Solo Leveling", "genre" => "Action", "cover" => "https://via.placeholder.com/300x450.png?text=Solo+Leveling"),
    array("id" => 3, "title" => "Omniscient Reader", "genre" => "Fantasy", "cover" => "https://via.placeholder.com/300x450.png?text=ORV"),
    array("id" => 4, "title" => "Tower of God", "genre" => "Fantasy", "cover" => "https://via.placeholder.com/300x450.png?text=Tower+of+God"),
    array("id" => 5, "title" => "Eleceed", "genre" => "Action", "cover" => "https://via.placeholder.com/300x450.png?text=Eleceed"),
    array("id" => 6, "title" => "True Beauty", "genre" => "Romance", "cover" => "https://via.placeholder.com/300x450.png?text=True+Beauty"),
);

foreach ($mock_comics as $comic) {
    $match_query = empty($query) || stripos($comic['title'], $query) !== false;
    $match_genre = empty($genre) || stripos($comic['genre'], $genre) !== false;
    
    if ($match_query && $match_genre) {
        $results[] = $comic;
    }
}

http_response_code(200);
echo json_encode($results);
?>
