-- Database schema for Nalderatoon
-- Create this in your phpMyAdmin

CREATE TABLE IF NOT EXISTS `users` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `name` VARCHAR(100) NOT NULL,
  `email` VARCHAR(100) NOT NULL UNIQUE,
  `password` VARCHAR(255) NOT NULL,
  `role` ENUM('admin', 'user', 'writer') DEFAULT 'user',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS `comics` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `title` VARCHAR(255) NOT NULL,
  `author` VARCHAR(100),
  `artist` VARCHAR(100),
  `description` TEXT,
  `cover_url` VARCHAR(255),
  `rating` DECIMAL(3,2) DEFAULT 0.0,
  `status` VARCHAR(50) DEFAULT 'Ongoing',
  `genre` VARCHAR(255),
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS `chapters` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `comic_id` INT,
  `title` VARCHAR(255) NOT NULL,
  `content_urls` TEXT, -- JSON array of image URLs
  `chapter_number` INT,
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (`comic_id`) REFERENCES `comics`(`id`) ON DELETE CASCADE
);

-- Insert Mock Data
INSERT INTO `users` (`name`, `email`, `password`, `role`) VALUES 
('Admin User', 'admin@nalderatoon.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin'),
('Regular User', 'user@nalderatoon.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'user');

INSERT INTO `comics` (`title`, `author`, `cover_url`, `rating`, `genre`) VALUES 
('The Beginning After The End', 'TurtleMe', 'https://via.placeholder.com/300x450.png?text=TBATE', 4.8, 'Fantasy, Action'),
('Solo Leveling', 'Chugong', 'https://via.placeholder.com/300x450.png?text=Solo+Leveling', 4.9, 'Action, Adventure');
